@extends('LifeAtGainup.Navbar.header')

@section('title', 'MERCHANDISER ORDER DETAILS')

@section('content')
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
<style>
   /*TAble popup*/

   #tip-first {
    display: none;
}
.select2-container .select2-selection--multiple .select2-selection__choice {
        color: #191818 !important;
    }

   .tooltip-inner {
    background-color: #add8e6;  /* Light blue background */
            color: black;  /* Text color */
            border: 1px solid #ccc;  /* Optional: Light border */
            padding: 10px;  /* Padding around the tooltip content */
            max-width: none;  /* Allow tooltip to adjust width automatically */
            white-space: normal; 
 
}

  
.status-container {
    display: flex;
    justify-content: flex-end; /* Pushes the status boxes to the end of the container */
    gap: 10px;
}

.status-box {
    width: 100px;
    height: 20px;
    display: flex;
    justify-content: center;
    align-items: center;
    color: #fff;
    font-weight: bold;
    border-radius: 5px;
}

.pending {
    background-color: red;
}

.done {
    background-color: green;
}

.late {
    background-color: orange;
}


   @media screen and (min-device-width: 1000px) and (max-device-width: 2400px) {

   .modal-contentt {
    position: relative;
    display: flex;
    flex-direction: column;
    width: 50%;
    margin-left: 25%;
    color: var(--bs-modal-color);
    pointer-events: auto;
    background-color: var(--bs-modal-bg);
    background-clip: padding-box;
    border: var(--bs-modal-border-width) solid var(--bs-modal-border-color);
    border-radius: var(--bs-modal-border-radius);
    outline: 0;
}
   }
   @media screen and (min-device-width: 3px) and (max-device-width: 900px) {
    .modal-contentt {
    position: relative;
    display: flex;
    flex-direction: column;
    width: 100%;

    color: var(--bs-modal-color);
    pointer-events: auto;
    background-color: var(--bs-modal-bg);
    background-clip: padding-box;
    border: var(--bs-modal-border-width) solid var(--bs-modal-border-color);
    border-radius: var(--bs-modal-border-radius);
    outline: 0;

}
   }
   .countBadge {
    position: absolute;
    top: -4px;
    right: -4px;
    background-color: red;
    color: white;
    border-radius: 50%;
    padding: 0px 2px;
    font-size: 8px;
    font-weight: bold;
        }
.caro_wid{

    width: 500px;
    height: 300px;
}
.caro_wid_center{
    justify-content: center;
    align-items: center;
    display: flex;
}

   .carousel-control-prev-icon,
.carousel-control-next-icon {
    background-color: red; /* Sets the background color to red */
    /* If you want to change the icon color itself, you may need to use a different approach depending on your setup */
}

.carousel-control-prev-icon,
.carousel-control-next-icon {
    /* For custom icons or to ensure proper visibility */
    background-size: 100%, 100%; /* Adjust if necessary */
    background-repeat: no-repeat;
    background-position: center;
}

.carousel-control-prev-icon:before,
.carousel-control-next-icon:before {
    /* Set a color for icons if they are font icons */
    color: red; /* This will work if icons are font icons like from FontAwesome */
}

   table.dataTable thead>tr>th.sorting, table.dataTable thead>tr>th.sorting_asc, table.dataTable thead>tr>th.sorting_desc, table.dataTable thead>tr>th.sorting_asc_disabled, table.dataTable thead>tr>th.sorting_desc_disabled, table.dataTable thead>tr>td.sorting, table.dataTable thead>tr>td.sorting_asc, table.dataTable thead>tr>td.sorting_desc, table.dataTable thead>tr>td.sorting_asc_disabled, table.dataTable thead>tr>td.sorting_desc_disabled {

 padding-right: 17px;
}
.greencolor, .greencolor td{
    background-color: #ff0d0d33 !important;
}
   .header-fixed {
                            position: sticky;
                            top: 0px;
                            background-color: white;
                          }
   .table_popup{
        font-size: 11px !important;
    }
    .modal_popup{
        max-width: 1250px !important;
    }

    .ocrstatuscon {
        max-height: 800px;
        overflow-y: auto;
        overflow-x: auto;
    }

    .ocrstatus {
        width: 100%;
        border-collapse: collapse;
    }

    .ocrstatus thead th {
        position: sticky;
        top: 0;
        background-color: #fff;
        z-index: 10;
    }

    .ocrstatus th,
    .ocrstatus td {
        white-space: nowrap;
        text-align: center;
    }

    .sideallign{
        text-align: end !important;
    }

    .dt-button.buttons-pdf,
        .dt-button.buttons-html5 {
            padding: 2px 9px !important;
        }

    table.dataTable.no-footer{
        border-top: 1px solid rgba(0, 0, 0, 0.3);
    }
    table.dataTable{
        border-top: 1px solid rgba(0, 0, 0, 0.3);
        border-bottom: 1px solid rgba(0, 0, 0, 0.3);
    }


    table.dataTable thead>tr>th.sorting, table.dataTable thead>tr>th.sorting_asc, table.dataTable thead>tr>th.sorting_desc, table.dataTable thead>tr>th.sorting_asc_disabled, table.dataTable thead>tr>th.sorting_desc_disabled, table.dataTable thead>tr>td.sorting, table.dataTable thead>tr>td.sorting_asc, table.dataTable thead>tr>td.sorting_desc, table.dataTable thead>tr>td.sorting_asc_disabled, table.dataTable thead>tr>td.sorting_desc_disabled {
        padding-right:17px !important;
    }

    .budget_abstract{
        width: 700px !important;
    font-size: 14px !important;
    }

    #noteText{
        color: blue !important;
    }

    .table-responsive {
    max-height: 500px; /* Adjust as needed */
    overflow-y: auto;
    scrollbar-width: none; /* For Firefox */
    -ms-overflow-style: none; /* For IE/Edge */
    }

    .table-responsive::-webkit-scrollbar {
        display: none; /* For Chrome, Safari, and Edge */
    }

    .table_popup thead th {
    font-weight: bold;
    }

    .table_popup tfoot td {
        font-weight: bold;
    }

    .highlight-yellow {
        background-color: #deef636b !important; 
    }

.highlight-green {
    background-color: #93ff8f45 !important; 
}

.highlight-red {
    background-color: #eea0936b !important; 
}

#dataTablee_wrapper .dt-buttons {
    margin-left: 15px;
    margin-top: 48px;
}

.centerallign{
    text-align: center !important;
}

    /* Your existing styles */
</style>

<div id="layout-wrapper">
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid mb-3">
            <div class="row">
                    <div class="col-xxl-12">
                        <div class="card">
                            <div class="card-header">
                            <div class="row">
                                    <div class="col-md-6">
                                        MERCHANDISER ORDER DETAILS
                                    </div>
                                    <div class="col-md-6">
                                    <div class="col-md-6 text-end">
                                        <a target="_blank" href="merchandiserordertechnotektest"
                                            class="btn btn-link"
                                            style="color: #ffffff; background-color: #007bff; padding: 8px 15px; border-radius: 5px; text-decoration: none; font-weight: bold; transition: all 0.3s ease;"
                                            onmouseover="this.style.backgroundColor='#0056b3'; this.style.color='#ffffff';"
                                            onmouseout="this.style.backgroundColor='#007bff'; this.style.color='#ffffff';">
                                            Try Beta Version
                                        </a>
                                    </div>
                                    </div>
                                   
                                </div>

                            </div>
                            <div class="card-body">

                            
                                <!-- Start of Form -->
                                <form id="filterForm">
                                <input type = 'hidden' class = 'defTabVal'  name = 'defTabVal' value ='1'>
                                    <div class="row">
                                        <!-- DIVISION -->
                                        <div class="col-md-3">
                                            <div class="mb-3">
                                                <label for="division" class="form-label">DIVISION</label>
                                                <select class="form-control select2 selectclass" name="division" id="division">
                                                    

                                                    <option value="Woven" selected="selected">Woven</option>

                                                    
                                                </select>
                                            </div>
                                        </div>


                                        <div class="col-md-3">
                                            <div class="mb-3">
                                                <label for="buyer_name" class="form-label">BUYER NAME
                                                <div id="spinner_BUY" class="spinner-border text-primary ms-2" role="status" style="display: none; width: 1rem; height: 1rem;">
                                                        <span class="visually-hidden">Loading...</span>
                                                    </div>
                                                    </label>
                                                <select class="form-control select2 selectclass" name="buyer_name[]" id="buyer_name" multiple="multiple">
                                                    <option value="">Select Buyer</option>
                                                    
                                                </select>
                                            </div>
                                        </div>

                                        <!-- BUYER PO / REF NO. -->
                                        <div class="col-md-3">
                                            <div class="mb-3">
                                                <label for="buyer_po" class="form-label">BRAND
                                                <div id="spinner_BRAN" class="spinner-border text-primary ms-2" role="status" style="display: none; width: 1rem; height: 1rem;">
                                                        <span class="visually-hidden">Loading...</span>
                                                       
                                                    </div>
                                                    </label>
                                                <select class="form-control select2 selectclass" name="brand[]" id="brand" multiple="multiple">
                                                    <option value="">Select Brand</option>
                                                    
                                                  
                                                
                                                    </select>
                                            </div>
                                        </div>

                                    <!-- OCN NO. -->
                                        <div class="col-md-3">
                                            <div class="mb-3">
                                                <label for="ocn_no" class="form-label">SEASON
                                                <div id="spinner_SEA" class="spinner-border text-primary ms-2" role="status" style="display: none; width: 1rem; height: 1rem;">
                                                        <span class="visually-hidden">Loading...</span>
                                                    </div> </label>
                                                <select class="form-control select2 selectclass" name="season[]" id="season" multiple="multiple"><option value="">--Select Season--</option>
                                                
                                               </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <!-- ORDER DATE -->
                                        <div class="col-md-3">
                                            <div class="mb-3">
                                                <label for="cc" class="form-label">CC
                                                <div id="spinner_CC" class="spinner-border text-primary ms-2" role="status" style="display: none; width: 1rem; height: 1rem;">
                                                        <span class="visually-hidden">Loading...</span>
                                                    </div>
                                                </label>
                                                <select class="form-control select2 selectclass" name="cc[]" id="cc" multiple="multiple"><option value="">--Select CC--</option>
                                                
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="mb-3">
                                                <label for="cc" class="form-label">MODEL + COLOR
                                                <div id="spinner_MOD" class="spinner-border text-primary ms-2" role="status" style="display: none; width: 1rem; height: 1rem;">
                                                        <span class="visually-hidden">Loading...</span>
                                                    </div>
                                                </label>
                                                <select class="form-control select2 selectclass" name="model_color[]" id="model_color" multiple="multiple"><option value="">--Select Model+Color--</option>
                                                
                                                </select>
                                            </div>
                                        </div>
                                        <!-- COMPLETE KIT DATE -->
                                        <!-- <div class="col-md-3">
                                            <div class="mb-3">
                                                <label for="kit_date" class="form-label">Plan Month
                                                </label>
                                                <input type="text" name="plan_month" id="plan_month"  value="" class="form-control " >
                                            </div>
                                        </div> -->

                                        <!-- SHIPMENT DATE --> 
                                        <div class="col-md-3">
                                            <div class="mb-1">
                                                <label for="ck_date" class="form-label">FRC CK From</label>
                                                <input type="text" name="ck_fdate" id="ck_fdate"  value="" placeholder="dd-mm-yyyy" class="form-control flatpickr-input" >
                                            </div>
                                            <div class="mb-2">
                                                <label for="ck_dfate" class="form-label">FRC CK To</label>
                                                <input type="text" name="ck_tdate" id="ck_tdate"  value="" placeholder="dd-mm-yyyy" class="form-control flatpickr-input" >
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="mb-1">
                                                <label for="shipment_date" class="form-label">SHIPMENT FromDATE</label>
                                                <input type="text" name="shipment_fdate" id="shipment_fdate"  value="" placeholder="dd-mm-yyyy" class="form-control flatpickr-input" >
                                            </div>
                                            <div class="mb-2">
                                                <label for="shipment_date" class="form-label">SHIPMENT ToDATE</label>
                                                <input type="text" name="shipment_tdate" id="shipment_tdate"  value="" placeholder="dd-mm-yyyy" class="form-control flatpickr-input" >
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="mb-3">
                                                <label for="merch_name" class="form-label">MERCHANDISER NAME</label>
                                                <select class="form-control select2 selectclass" name="merch_name[]" id="merch_name" multiple="multiple"><option value="">--Select Merchandiser Name--</option>
                                                
                                            </select>
                                            </div>
                                        </div>
                                        <input type="hidden" name="emp_id" id="emp_id" value="{{Session('empl_id')}}">
                                        <!-- <div class="col-md-3">
                                            <div class="mb-3">
                                                <label for="file_status" class="form-label">File STATUS</label>
                                                <select class="form-control select2" name="file_status" id="file_status">
                                                    <option value="">--Select Status--</option>
                                                    <option value="Pending">Pending</option>
                                                    <option value="Closed">Closed</option>
                                                </select>
                                            </div>
                                        </div> -->


                                     <!-- ORDER STATUS -->
                                    

                                    </div>
                                    <div class="row">
                                  
                                    </div>

                                    <!-- Submit Button -->
                                    <div class="row mt-3">
                                        <div class="col-md-12">
                                            <button type="submit"  id= 'filter_button' class="btn btn-primary">Filter</button>
                                            <button type="button" id="resetButton" class="btn btn-secondary">Reset</button>

                                        </div>
                                        <div id="preloder" style="display: none;">
                                            <div class="lds-hourglass">

                                            </div>
                                    </div>
                            </form>

                             <div class="table-responsive mt-4 table-card">
                                    <table class="table table-hover table_popup table-centered align-middle" id="dataTablee">
                                   


                                        <tfoot style = "position :sticky; bottom: 0; z-index : 10">
                                                <tr>
                                                    <th colspan="7">Total</th>
                                                    
                                                    <th id="totalSelQty"></th>
                                                    
                                                
                                                    
                                                    <th ></th>
                                                    <th ></th>
                                                    <th id="totalprodQty"></th>
                                                    <th id="totalcfmQty"></th>
                                                    <th id="totalshdiffQty"></th>
                                                    <th id="totalshippQty"></th>
                                                    <th id="totalshipdiff"></th>
                                                    <th ></th>
                                                    <th id="totalshipQty"></th>
                                                    <th id="totalshortship"></th>
                                                    <th ></th>
                                                    <th ></th>
                                                    <th id = "totalfg"></th>
                                                    <th id ="totalunmapfg"></th>
                                                    <th id = "totalfabric"></th>
                                                    <th id = "totalunmapfabric"></th>
                                                    <th id ="totaltim"></th>
                                                    <th id="totalunmaptrim"></th>
                                                    
                                                </tr>
                                            </tfoot>
                                        <thead class="text-muted table-light" style="font-size: 11px;">
                                            <tr>
                                            <th style="position: sticky; top: 0; background: white; z-index: 10;">SNO</th>
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">CC
                                                </th>
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">Model + Color
                                                </th>
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">DMI /DSI
                                                </th>
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">Season
                                                </th>
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">FRC/CK Date
                                                </th>
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">Shipped Date
                                                </th>
                                              
                                               
                                                
                                               
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">Sel Qty
                                                </th>
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">Proj Qty
                                                </th>
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">FRC Qty
                                                </th>
                                               
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">C/O Qty
                                                </th>
                                              
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">Prod Qty
                                                </th>
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">Buyer Po Qty
                                                </th>
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">Ship Qty

                                                </th>
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">Ship Diff</th>
                                                <!-- <th style="position: sticky; top: 0; background: white; z-index: 10;">PO's Status</th> -->
                                                <th style="position: sticky; top: 0; background: white; z-index: 5;">Prod Status

                                                </th>
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">Past EHD

                                                </th>
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">Short Ship
                                                </th>
                                                
                                               
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">Brand
                                                </th>
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">Merch
                                                </th>
                                                <th style="position: sticky; top: 0; background: white; z-index: 5;">FG(In Pcs)
                                                </th>
                                                <th style="position: sticky; top: 0; background: white; z-index: 5;">Unmap FG
                                                </th>
                                                <th style="position: sticky; top: 0; background: white; z-index: 5;">Fabric(In Mtr)
                                                </th>
                                                <th style="position: sticky; top: 0; background: white; z-index: 5;">Unmap Fabric
                                                </th>
                                                <th style="position: sticky; top: 0; background: white; z-index: 5;">Trim(In Val)
                                                </th>
                                                <th style="position: sticky; top: 0; background: white; z-index: 5;">Unmap Trim
                                                </th>
                                            </tr>
                                        </thead>
                                        
                                        <tbody style="font-size: 11px">
                                            <!-- Data will be loaded here via AJAX -->
                                          
                                        </tbody>
                                    </table>
                              
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            </div>
        </div>
    </div>
</div>






<div class="modal fade" id="tableModalocrstatus" tabindex="-1" aria-labelledby="tableModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal_popup">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title " id="tableModalLabel">Projection Status</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
            <div class="table-container ocrstatuscon">
            <!-- <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#exampleModal">
                Launch demo modal
            </button> -->

            <div class="row">

                    <div class="col-md-3 mb-3">
                        <select id="colorDropdown" class="form-select">
                            <option value="">Select PRJ NO</option>
                        </select>
                    </div>

                    <div class="col-md-3 mb-3">
                        <select id="itemDropdown" class="form-select">
                            <option value="">Select MOdel</option>
                        </select>
                    </div>
                   
                    <div class="col-md-3 mb-3">
                        <select id="sizeDropdown" class="form-select">
                            <option value="">Select FABRIC</option>
                        </select>
                    </div>

                    <div class="col-md-3 mb-3">
                            <select id="stsDropdown" class="form-select">
                                <option value="">Select Status</option>
                            </select>
                        </div>
                </div>
            
            <table class="table table-bordered table_popup table_production" id="detailsTable">
                <thead class="header-fixed">
                    
                    <tr>
                        <th >S.No</th>
                        <th>PRJ No</th>
                        <th> PRJDATE</th>
                        <th>  APPDATE</th>
                        <th>  CK_DATE</th>
                        <th>  SHIPDATE</th>
                        <th >PRJ QTY</th>
                        <th >MODEL Code</th>
                        <th >Item Code</th>
                        <th >FABRIC</th>
                        <th >REQ QTY</th>
                        <th >REQ Val</th>
                        <th >PO QTY</th>
                        <th >PO val</th>

                        <th >GRN QTY</th>
                        <th >GRN val</th>
                        <th >GRN Rej QTY</th>
                        <th >UOM</th> 
                        <th >PO PND</th>
                        <th >GRN PND</th>
                        <th >CONS / PCS</th>
                        <th >PLAN PO FG QTY</th>
                        <th >GRN FG QTY</th>
                        <th >Src</th>
                        <th >LEAD DAYS</th>
                        <th>Status</th>
                    </tr>
                    
                </thead>
                <tbody>
              
                   
                    
                </tbody>
                <tfoot>
                        <tr>
                            <th colspan="6" class="sideallign">Total:</th>
                            <th id="totalPRJQty" class="sideallign"></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th id="totalReqQty" class="sideallign"></th>
                            <th id="totalPOQty" class="sideallign"></th>
                            <th id="totalGRNQty" class="sideallign"></th>
                            <th id="totalGRNREJQty" class="sideallign"></th>
                            <th></th>
                            <th id="totalPOPENQty" class="sideallign"></th>
                            <th id="totalGRNPENQty" class="sideallign"></th>
                            <th id="totalCONPCSQty" class="sideallign"></th>
                            <th id="totalPLANFGQty" class="sideallign"></th>
                            <th id="totalGRNFGQty" class="sideallign"></th>
                            <th colspn = '5'></th>
                            <th></th>
                            <th></th>
                        </tr>
                    </tfoot>
            </table>
            </div>

            </div>
            <!-- <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div> -->
        </div>
    </div>
</div>

<div class="modal " id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Filter Search</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
     
  <div class="form-group">
    <label for="exampleInputEmail1">Pro Number</label>
    <select id="pro_number" class="form-select">
                            <option value="">Select Item</option>
    </select>
  </div>
  <div class="form-group">
    <label for="exampleInputPassword1">App Date</label>
    <input type="text" name="ck_date" id="app_date"  value="" placeholder="dd-mm-yyyy" class="form-control flatpickr-input" readonly="readonly">
    
  </div>
 
  <button  class="btn btn-primary tadetails_search">Submit</button>

      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        <button type="button" class="btn btn-primary">Save changes</button>
      </div>
    </div>
  </div>
</div>



<div class="modal fade" id="tableModalfcrstatus" tabindex="-1" aria-labelledby="tableModalLabelFRC" aria-hidden="true">
    <div class="modal-dialog modal-lg modal_popup">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title " id="tableModalLabelFRC">FRC Status</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
            <div class="table-container ocrstatuscon">
            <div class="row">

                <div class="col-md-3 mb-3">
                    <select id="prjDropdown" class="form-select">
                        <option value="">Select PRJ NO</option>
                    </select>
                </div>

                <div class="col-md-3 mb-3">
                    <select id="modelDropdown" class="form-select">
                        <option value="">Select MOdel</option>
                    </select>
                </div>

                <div class="col-md-3 mb-3">
                    <select id="trimDropdown" class="form-select">
                        <option value="">Select FABRIC</option>
                    </select>
                </div>
                <div class="col-md-3 mb-3">
                    <select id="trimtypeDropdown" class="form-select">
                        <option value="">Select Type</option>
                    </select>
                </div>
                <div class="col-md-3 mb-3">
                    <select id="frcstsDropdown" class="form-select">
                        <option value="">Select Status</option>
                    </select>
                </div>
            </div>

            
            
            <table class="table table-bordered table_popup tableproduction" id="detailsTable_frc">
                <thead class="header-fixed">
                    <tr>
                    <th colspan="38" style="text-align: left;" class = "frc_status_qty">GIL/OCN03990</th>
                    </tr>
                    <tr>
                        <th >S.No</th>
                        <th>FRC No</th>
                        <th>FRCDATE</th>
                        <th>APPDATE</th>
                        <th>CKDATE</th>
                        <th>SHIPDATE</th>
                        <th >FRC QTY</th>
                        <th >MODEL Code</th>
                        <th >Item Code</th>
                        <th >TRIMS</th>
                        <th >REQ QTY</th>
                        <th >REQ Val</th>
                        <th >PO QTY</th>
                        <th >PO Val</th>
                        <th >GRN QTY</th>
                        <th >GRN Val</th>
                        <th >UOM</th>
                        <th >PO PND</th>
                        <th >GRN PND</th>
                        <th >CONS / PCS</th>
                        <th >PLAN PO FG QTY</th>
                        <th >GRN FG QTY</th>
                        <th >Src</th>
                        <th >LEAD DAYS</th>
                        <th >Type</th>
                        <th>Status</th>
                    </tr>
                  
                </thead>
                <tbody>
              
                   
                   
                </tbody>

                <tfoot>
                        <tr>
                            <th colspan="6" class="sideallign">Total:</th>
                            <th id="totalPRJQty1" class="sideallign"></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th id="totalReqQty1" class="sideallign"></th>
                            <th id="totalPOQty1" class="sideallign"></th>
                            <th id="totalGRNQty1" class="sideallign"></th>
                           
                           <th></th>
                            <th id="totalPOPENQty1" class="sideallign"></th>
                            <th id="totalGRNPENQty1" class="sideallign"></th>
                            <th id="totalCONPCSQty1" class="sideallign"></th>
                            <th id="totalPLANFGQty1" class="sideallign"></th>
                            <th id="totalGRNFGQty1" class="sideallign"></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                        </tr>
                    </tfoot>

            </table>
            </div>

            </div>
            <!-- <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div> -->
        </div>
    </div>
</div>















<div id="tip-first" class="tip-content hidden">
    
<div class="container ">
    <div class="row">
        <!-- This column will take up 6 out of 12 columns (50% of the width) -->
        <div class="col-6">
            <p> Consumption</p>
            <hr>
            <p>METER</p>
        </div>

        <!-- Another column that also takes up 6 out of 12 columns (50% of the width) -->
        <div class="col-6">
        <p>Shipped QTY</p>
            <hr>
            <p>KG</p>
        </div>
    </div>
</div>

</div>



@endsection


@section('script')

<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
<!-- FixedColumns CSS -->





<script>
var productionTable; 
function initializeDataTable() {
    if ($.fn.dataTable.isDataTable('#detailsTable')) {
        return; 
    }
    productionTable = $('#detailsTable').DataTable({
        paging: false,  
        searching: true,  
        ordering: true,  
        responsive: true, 
        order: [[0, 'asc']],  
        columnDefs: [
            {
                targets: [2, 3, 4, 5], 
                type: 'date-dd-mm-yyyy'  
            },
        ],
        dom: 'Bfrtip',  
        buttons: [
            {
                extend: 'excelHtml5',
                title: 'PRODUCTION DETAILS',
                exportOptions: {
                    columns: ':visible'
                },
                footer: true
            },
            {
                extend: 'pdfHtml5',
                text: 'PDF',
                titleAttr: 'PROJ DETAILS',
                orientation: 'landscape',
                pageSize: 'A3',
                exportOptions: {
                    columns: ':visible'
                },
                customize: function(doc) {
                    doc.defaultStyle.fontSize = 7; 
                    doc.content[1].table.widths = 'auto';  
                    doc.content[1].table.dontBreakRows = true;  
                }
            }
        ],
        footerCallback: function (row, data, start, end, display) {
            calculatePRJTotals(this.api().rows({ search: 'applied' }).data().toArray());
        }
    });
}

function calculatePRJTotals(data) {
            let totalPRJQty = 0;
            let totalReqQty = 0;
            let totalPOQty= 0;
            let totalGRNQty= 0;
            let totalGRNREJQty= 0;
            let totalPOPENQty= 0;
            let totalGRNPENQty= 0;
            let totalCONPCSQty= 0;
            let totalPLANFGQty= 0;
            let totalGRNFGQty= 0;

            data.forEach(function (rowData) {
                totalPRJQty += parseFloat(rowData[6]) || 0;
                totalReqQty += parseFloat(rowData[10]) || 0;
                totalPOQty += parseFloat(rowData[11]) || 0;                
                // totalGRNQty += parseFloat(rowData[12]) || 0;  
                const grnQty = $(rowData[12]).text().trim();
                totalGRNQty += parseFloat(grnQty) || 0;

                totalGRNREJQty += parseFloat(rowData[13]) || 0;                
                totalPOPENQty += parseFloat(rowData[15]) || 0;                
                totalGRNPENQty += parseFloat(rowData[16]) || 0;                
                totalCONPCSQty += parseFloat(rowData[17]) || 0;                
                totalPLANFGQty += parseFloat(rowData[18]) || 0;                
                totalGRNFGQty += parseFloat(rowData[18]) || 0;                
            });

            $('#totalPRJQty').text(totalPRJQty.toFixed(2));
            $('#totalReqQty').text(totalReqQty.toFixed(2));
            $('#totalPOQty').text(totalPOQty.toFixed(2));
            $('#totalGRNQty').text(totalGRNQty.toFixed(2));
            $('#totalGRNREJQty').text(totalGRNREJQty.toFixed(2));
            $('#totalPOPENQty').text(totalPOPENQty.toFixed(2));
            $('#totalGRNPENQty').text(totalGRNPENQty.toFixed(2));
            $('#totalCONPCSQty').text(totalCONPCSQty.toFixed(2));
            $('#totalPLANFGQty').text(totalPLANFGQty.toFixed(2));
            $('#totalGRNFGQty').text(totalGRNFGQty.toFixed(2));

}
initializeDataTable();

$(document).on('click', '.tadetails', function() {
    
    let division = $(this).data('division');
    let ccNo = $(this).data('cc-no');
    let modelColor = $(this).data('model_color');
   
    $('#tableModalocrstatus').data('cc-no', ccNo)
                              .data('division', division)
                              .data('model_color', modelColor);

   
    $('#tableModalocrstatus').modal('show');
});


let isAjaxInProgress = false;


$('#tableModalocrstatus').on('shown.bs.modal', function () {
   
    if (isAjaxInProgress) {
        console.log('An AJAX request is already in progress.');
        return; 
    }

   
    isAjaxInProgress = true;
    let CostID = $(this).data('cc-no');
    let division = $(this).data('division');
    let model_color = $(this).data('model_color');
    let Fckdate = $('#ck_fdate').val();
    let tckdate =  $('#ck_tdate').val();
    let shfckdate =  $('#shipment_fdate').val();
    let shtckdate =  $('#shipment_tdate').val();
  
    $('.prj_status_qty').text('PRJ STATUS - ' + model_color);

    clearFiltersAndSelections();
    $.ajax({
        url: "{{ route('prjstatus') }}",  
        method: 'GET',
        data: {
            costId: CostID,
            division: division,
            fckdate:Fckdate,
            tckdate:tckdate,
            shfckdate:shfckdate,
            shtckdate:shtckdate
            

        },
        headers: {
            "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content")
        },
        dataType: 'json',
        beforeSend: function () {
            $("#preloder").fadeIn();
                },
        success: function (response) {
           
            populateTable(response.data);
        },
        error: function (xhr, status, error) {
            console.error('Error fetching data:', error);
        },
        complete: function () {
            $("#preloder").fadeOut();
            isAjaxInProgress = false;
        }
    });
});

function clearFiltersAndSelections() {
    const productionTable = $('#detailsTable').DataTable();

    // Clear DataTable search
    productionTable.search('').columns().search('').draw();

    // Reset dropdowns
    $('#colorDropdown').val('');
    $('#itemDropdown').val('');
    $('#sizeDropdown').val('');
    $('#stsDropdown').val('');

    // Remove any active search filters on the dropdowns
    $('#colorDropdown').trigger('change');
    $('#itemDropdown').trigger('change');
    $('#sizeDropdown').trigger('change');
    $('#stsDropdown').trigger('change');
}


function populateTable(data) {
    const productionTable = $('#detailsTable').DataTable();
    const $tableBody = $('#detailsTable tbody');
    const $colorDropdown = $('#colorDropdown');
    const $itemDropdown = $('#itemDropdown');
    const $sizeDropdown = $('#sizeDropdown');
    const $stsDropdown = $('#stsDropdown');

    // Clear the table body
    $tableBody.empty();
    
    let Colors = [];
    let Item = [];
    let Size = [];
    let Status = [];

    // Clear previous data from the DataTable
    productionTable.clear();

    // If no data is passed, return early
    if (data.length === 0) {
        productionTable.draw();
        return;
    }

    // Populate table rows with data
    data.forEach(function (item, index) {
        // Handle the case where Order_NO may be undefined or null
        var part2 = item.Order_NO ? item.Order_NO.substring(item.Order_NO.length - 8) : 'N/A'; 

        // Collect unique values for dropdowns
        Colors.push(part2);
        Item.push(item.Model_COde);
        Size.push(item.Fabric);
        Status.push(item.PO_Status);

        const grnQty = parseInt(item.GRN_Qty) || 0;
        const grnColor = item.Ck_Color || 'black'; 
        const po_date = item.PODate || "-";

        const rowData = [
            index + 1, 
            `<span title="${item.Order_NO}">${part2}</span>`,
            formatDateCk(item.Order_Date),
            formatDateCk(item.Approval_Date),
            formatDateCk(item.CK_Date),
            formatDateCk(item.Ship_Date),
            item.Prj_Qty,
            item.Model_COde,
            item.Item_Code,
            item.Fabric,
            parseInt(item.Req_Qty) || 0,
            item.Req_Val,
            parseInt(item.PO_Qty) || 0,
            item.Po_Val,
            `<span style="color: ${grnColor}; font-weight: bold;" title="PO Date:${po_date}">${grnQty}</span>`,
            // parseInt(item.GRN_Qty) || 0,
            item.Grn_Val,
            (item.Rej_Qty !== '.000') ? parseInt(item.Rej_Qty) : 0,
            item.UOM,
            item.PO_Pending,
            (item.GRN_Pending !== '.000') ? parseInt(item.GRN_Pending) : 0,
            item.Cons,
            parseInt(item.PO_Qty_FG),
            parseInt(item.GRN_Qty_FG),
            item.Source,
            item.LeadDays,
            item.PO_Status
        ];

        productionTable.row.add(rowData);
    });

    // Remove duplicates and update dropdowns
    Colors = [...new Set(Colors)];
    Item = [...new Set(Item)];
    Size = [...new Set(Size)];
    Status = [...new Set(Status)];

    // Populate the color dropdown
    $colorDropdown.empty();
    $colorDropdown.append('<option value="">All PRJ</option>');
    Colors.forEach(function (color) {
        $colorDropdown.append(`<option value="${color}">${color}</option>`);
    });

    // Populate the item dropdown
    $itemDropdown.empty();
    $itemDropdown.append('<option value="">All Model</option>');
    Item.forEach(function (item) {
        $itemDropdown.append(`<option value="${item}">${item}</option>`);
    });

    // Populate the size dropdown
    $sizeDropdown.empty();
    $sizeDropdown.append('<option value="">All Fabric</option>');
    Size.forEach(function (size) {
        $sizeDropdown.append(`<option value="${size}">${size}</option>`);
    });

    // Populate the Status dropdown
    $stsDropdown.empty();
        $stsDropdown.append('<option value="">All Status</option>');
        Status.forEach(function(sts) {
            $stsDropdown.append(`<option value="${sts}">${sts}</option>`);
        });

    // Draw the table
    productionTable.draw();

    // Event listeners for dropdowns
    $colorDropdown.off('change').on('change', function () {
        const selectedColor = $(this).val();
        if (selectedColor === "") {
            productionTable.columns(1).search('').draw(); // Assuming Color is in the second column
        } else {
            productionTable.columns(1).search('^' + selectedColor + '$', true, false).draw(); // Adjusted index
        }

        const filteredData = productionTable.rows({ search: 'applied' }).data().toArray();
        calculatePRJTotals(filteredData);
    });

    $sizeDropdown.off('change').on('change', function () {
        const selectedSize = $(this).val();
        if (selectedSize === "") {
            productionTable.columns(9).search('').draw(); // Assuming Size is in the fourth column
        } else {
            productionTable.columns(9).search('^' + selectedSize + '$', true, false).draw(); // Adjusted index
        }

        const filteredSizeData = productionTable.rows({ search: 'applied' }).data().toArray();
        calculatePRJTotals(filteredSizeData);
    });

    $stsDropdown.off('change').on('change', function() {
            const selectedSts = $(this).val();
            if (selectedSts === "") {
                productionTable.columns(22).search('').draw(); // Assuming Size is in the fourth column
            } else {
                productionTable.columns(22).search('^' + selectedSts + '$', true, false).draw(); // Adjusted index
            }

            const filteredStsData = productionTable.rows({
                search: 'applied'
            }).data().toArray();
            calculatePRJTotals(filteredStsData);
    });

    $itemDropdown.off('change').on('change', function () {
        const selectedItem = $(this).val();
        if (selectedItem === "") {
            productionTable.columns(7).search('').draw(); // Assuming Item is in the eighth column
        } else {
            productionTable.columns(7).search('^' + selectedItem + '$', true, false).draw(); // Adjusted index
        }

        const filteredItemData = productionTable.rows({ search: 'applied' }).data().toArray();
        calculatePRJTotals(filteredItemData);
    });
}




//end prj Popup

//start FCR Popup



var productionFRcTable; 
function initializeDataFRCTable() {
    if ($.fn.dataTable.isDataTable('#detailsTable_frc')) {
        return; 
    } 
    productionFRcTable = $('#detailsTable_frc').DataTable({ 
        paging: false,  
        searching: true,  
        ordering: true,  
        responsive: true, 
        order: [[0, 'asc']],  
        columnDefs: [
            {
                targets: [2, 3, 4, 5], 
                type: 'date-dd-mm-yyyy'  
            },
        ],
        dom: 'Bfrtip',  
        buttons: [
            {
                extend: 'excelHtml5',
                title: 'FRC DETAILS',
                exportOptions: {
                    columns: ':visible'
                },
                footer: true
            },
            {
                extend: 'pdfHtml5',
                text: 'PDF',
                titleAttr: 'FRC DETAILS',
                orientation: 'landscape',
                pageSize: 'A3',
                exportOptions: {
                    columns: ':visible'
                },
                customize: function(doc) {
                    doc.defaultStyle.fontSize = 6; 
                   
                }
            }
        ],
        footerCallback: function (row, data, start, end, display) {
            calculateFRCDetailsTotals(this.api().rows({ search: 'applied' }).data().toArray()); 
        }
    });
}
function calculateFRCDetailsTotals(data) {
    
            let totalPRJQty = 0;
            let totalReqQty1 = 0;
            let totalPOQty1= 0;
            let totalGRNQty1= 0;
            let totalGRNREJQty1= 0;
            let totalPOPENQty1= 0;
            let totalGRNPENQty1= 0;
            let totalCONPCSQty1= 0;
            let totalPLANFGQty1= 0;
            let totalGRNFGQty1= 0;
            let totalPRJQty1= 0;

            data.forEach(function (rowData) {
                totalPRJQty1 += parseFloat(rowData[6]) || 0;
                totalReqQty1 += parseFloat(rowData[10]) || 0;
                totalPOQty1 += parseFloat(rowData[11]) || 0;                
                // totalGRNQty1 += parseFloat(rowData[12]) || 0;
                
                const grnQty = $(rowData[12]).text().trim();
                totalGRNQty1 += parseFloat(grnQty) || 0;
                              
                totalPOPENQty1 += parseFloat(rowData[14]) || 0;                
                totalGRNPENQty1 += parseFloat(rowData[15]) || 0;                
                totalCONPCSQty1 += parseFloat(rowData[16]) || 0;                
                totalPLANFGQty1 += parseFloat(rowData[17]) || 0;                
                totalGRNFGQty1 += parseFloat(rowData[18]) || 0;                
            });

            $('#totalPRJQty1').text(totalPRJQty1.toFixed(2));
            $('#totalReqQty1').text(totalReqQty1.toFixed(2));
            $('#totalPOQty1').text(totalPOQty1.toFixed(2));
            $('#totalGRNQty1').text(totalGRNQty1.toFixed(2));
            $('#totalGRNREJQty1').text();
            $('#totalPOPENQty1').text(totalPOPENQty1.toFixed(2));
            $('#totalGRNPENQty1').text(totalGRNPENQty1.toFixed(2));
            $('#totalCONPCSQty1').text(totalCONPCSQty1.toFixed(2));
            $('#totalPLANFGQty1').text(totalPLANFGQty1.toFixed(2));
            $('#totalGRNFGQty1').text(totalGRNFGQty1.toFixed(2));


    

}
initializeDataFRCTable();

$(document).on('click', '.fcr_tadetails', function() {
    
    let division = $(this).data('division');
    let ccNo = $(this).data('cc-no');
    let modelColor = $(this).data('model_color');
   
    $('#tableModalfcrstatus').data('cc-no', ccNo)
                              .data('division', division)
                              .data('model_color', modelColor);

   
    $('#tableModalfcrstatus').modal('show');
});


let isAjaxFRCInProgress = false;


$('#tableModalfcrstatus').on('shown.bs.modal', function () {
   
    if (isAjaxFRCInProgress) {
        console.log('An AJAX request is already in progress.');
        return; 
    }

   
    isAjaxFRCInProgress = true;
    let CostID = $(this).data('cc-no');
    let division = $(this).data('division');
    let model_color = $(this).data('model_color');
      let Fckdate = $('#ck_fdate').val();
    let tckdate =  $('#ck_tdate').val();
    let shfckdate =  $('#shipment_fdate').val();
    let shtckdate =  $('#shipment_tdate').val();
    console.log(model_color);
    $('.frc_status_qty').text('FRC STATUS - ' + model_color);

    clearFiltersAndSelectionsFRC();
    $.ajax({
        url: "{{ route('fcrstatus') }}",  
        method: 'GET',
        data: {
            costId: CostID,
            division: division,
            fckdate:Fckdate,
            tckdate:tckdate,
            shfckdate:shfckdate,
            shtckdate:shtckdate
        },
        headers: {
            "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content")
        },
        dataType: 'json',
        beforeSend: function () {
            $("#preloder").fadeIn();
                },
        success: function (response) {
           
            FRCTable(response.data);
        },
        error: function (xhr, status, error) {
            console.error('Error fetching data:', error);
        },
        complete: function () {
            $("#preloder").fadeOut();
            isAjaxFRCInProgress = false;
        }
    });
});


function clearFiltersAndSelectionsFRC(){
    
    const productionFRcTable = $('#detailsTable_frc').DataTable();

    // Clear DataTable search
    productionFRcTable.search('').columns().search('').draw();

    // Reset dropdowns
    $('#prjDropdown').val('');
    $('#modelDropdown').val('');
    $('#trimDropdown').val('');

    // Remove any active search filters on the dropdowns
    $('#prjDropdown').trigger('change');
    $('#modelDropdown').trigger('change');
    $('#trimDropdown').trigger('change');

}


function FRCTable(data) {
    const productionFRcTable = $('#detailsTable_frc').DataTable();
    const $tableBody = $('#detailsTable_frc tbody');
    const $prjDropdown = $('#prjDropdown');
    const $modelDropdown = $('#modelDropdown');
    const $trimDropdown = $('#trimDropdown');
    const $trimtypeDropdown = $('#trimtypeDropdown');
    const $frcstsDropdown = $('#frcstsDropdown');

    // Clear the table body
    $tableBody.empty();
    let Prj = [];
    let Model = [];
    let Trim = [];
    let Trimtype = [];
    let Status = [];

    productionFRcTable.clear();

    if (data.length === 0) {
        productionFRcTable.draw();
        return;
    }

    // Populate the table rows
    data.forEach(function (item, index) {
        var part2 = item.Order_NO ? item.Order_NO.substring(item.Order_NO.length - 8) : 'N/A'; // Default if Order_NO is not available
        Prj.push(part2);
        Model.push(item.Model_COde);
        Trim.push(item.Trim_Item);
        Trimtype.push(item.Trim_Type);
        Status.push(item.PO_Status);
        
        const grnQty = parseInt(item.GRN_Qty) || 0;
        const grnColor = item.Ck_Color || 'black'; // Default to 'black' if Ck_Color is not specified
        const po_date = item.PODate || "-";

        const rowData = [
            index + 1, 
            `<span title="${item.Order_NO}">${part2}</span>`,
            formatDateCk(item.Order_Date),
            formatDateCk(item.Approval_Date),
            formatDateCk(item.CK_Date),
            formatDateCk(item.Ship_Date),
            item.FRC_Qty,
            item.Model_COde,
            item.Item_Code,
            item.Trim_Item,
            parseInt(item.Req_Qty) || 0,
            item.Req_Val,
            parseInt(item.PO_Qty) || 0,
            item.Po_Val,
            `<span style="color: ${grnColor}; font-weight: bold;" title="PO Date:${po_date}">${grnQty}</span>`,
            // parseInt(item.GRN_Qty) || 0,
            item.Grn_Val,
            item.UOM,
            item.PO_Pending,
            (item.GRN_Pending != '.000') ? parseInt(item.GRN_Pending) : 0,
            item.Cons,
            parseInt(item.PO_Qty_FG),
            parseInt(item.GRN_Qty_FG),
            item.Source,
            item.LeadDays,
            item.Trim_Type,
            item.PO_Status,
            ''
        ];

        productionFRcTable.row.add(rowData);
    });

    // Remove duplicates for dropdowns and populate
    Prj = [...new Set(Prj)];
    Model = [...new Set(Model)];
    Trim = [...new Set(Trim)];
    Trimtype = [...new Set(Trimtype)];
    Status = [...new Set(Status)];

    // Populate the PRJ dropdown
    $prjDropdown.empty();
    $prjDropdown.append('<option value="">All Trim</option>');
    Prj.forEach(function (prj) {
        $prjDropdown.append(`<option value="${prj}">${prj}</option>`);
    });

    // Populate the Model dropdown
    $modelDropdown.empty();
    $modelDropdown.append('<option value="">All Model</option>');
    Model.forEach(function (model) {
        $modelDropdown.append(`<option value="${model}">${model}</option>`);
    });

    // Populate the Trim dropdown
    $trimDropdown.empty();
    $trimDropdown.append('<option value="">All Trim</option>');
    Trim.forEach(function (trim) {
        $trimDropdown.append(`<option value="${trim}">${trim}</option>`);
    });

    $trimtypeDropdown.empty();
    $trimtypeDropdown.append('<option value="">All Type</option>');
    Trimtype.forEach(function (trimtype) {
        $trimtypeDropdown.append(`<option value="${trimtype}">${trimtype}</option>`);
    });
     // FRC TABLE STATUS
    $frcstsDropdown.empty();
        $frcstsDropdown.append('<option value="">All Status</option>');
        Status.forEach(function(sts) {
            $frcstsDropdown.append(`<option value="${sts}">${sts}</option>`);
    });

    // Redraw the table with the new rows
    productionFRcTable.draw();

    // Event listener for the PRJ dropdown change
    $prjDropdown.off('change').on('change', function () {
        const selectedPrj = $(this).val();

        // Clear the search on PRJ column (column index 1)
        if (selectedPrj === "") {
            productionFRcTable.columns(1).search('').draw(); // PRJ is in the second column (index 1)
        } else {
            productionFRcTable.columns(1).search('^' + selectedPrj + '$', true, false).draw(); // Filter by selected PRJ
        }

        // Optionally, update the totals or perform other operations
        const filteredData = productionFRcTable.rows({ search: 'applied' }).data().toArray();
        // calculateDetailsTotals(filteredData);
    });

    // Event listener for the Model dropdown change
    $modelDropdown.off('change').on('change', function () {
        const selectedModel = $(this).val();

        if (selectedModel === "") {
            productionFRcTable.columns(7).search('').draw(); // Model is in column index 7
        } else {
            productionFRcTable.columns(7).search('^' + selectedModel + '$', true, false).draw(); // Filter by Model
        }

        // Optionally, update the totals
        const filteredModelData = productionFRcTable.rows({ search: 'applied' }).data().toArray();
        // calculateDetailsTotals(filteredModelData);
    });

    // Event listener for the Trim dropdown change
    $trimDropdown.off('change').on('change', function () {
        const selectedTrim = $(this).val();

        if (selectedTrim === "") {
            productionFRcTable.columns(9).search('').draw(); // Trim is in column index 9
        } else {
            productionFRcTable.columns(9).search('^' + selectedTrim + '$', true, false).draw(); // Filter by Trim
        }

        // Optionally, update the totals
        const filteredTrimData = productionFRcTable.rows({ search: 'applied' }).data().toArray();
        // calculateDetailsTotals(filteredTrimData);
    });
    $trimtypeDropdown.off('change').on('change', function () {
        const selectedTrimtype = $(this).val();

        if (selectedTrimtype === "") {
            productionFRcTable.columns(21).search('').draw(); // Trim is in column index 9
        } else {
            productionFRcTable.columns(21).search('^' + selectedTrimtype + '$', true, false).draw(); // Filter by Trim
        }

        // Optionally, update the totals
        const filteredTrimData = productionFRcTable.rows({ search: 'applied' }).data().toArray();
        // calculateDetailsTotals(filteredTrimData);
    });
    // FRC TABLE STATUS
    $frcstsDropdown.off('change').on('change', function() {
            const selectedStatus = $(this).val();

            if (selectedStatus === "") {
                productionFRcTable.columns(22).search('').draw(); // Trim is in column index 9
            } else {
                productionFRcTable.columns(22).search('^' + selectedStatus + '$', true, false).draw(); // Filter by Trim
            }

            // Optionally, update the totals
            const filteredStatus = productionFRcTable.rows({
                search: 'applied'
            }).data().toArray();
            // calculateDetailsTotals(filteredTrimData);
    });

    // Draw the table after applying all changes
    productionFRcTable.draw();
}




    document.addEventListener("DOMContentLoaded", function() {
        // Initialize Flatpickr
        flatpickr("#shipment_fdate", {
            dateFormat: "d-m-Y",
           
            allowInput: true,
        });
        flatpickr("#shipment_tdate", {
            dateFormat: "d-m-Y",
           
            allowInput: true,
        });
    });

    document.addEventListener("DOMContentLoaded", function() {
        // Initialize Flatpickr
        flatpickr("#order_date", {
            dateFormat: "d-m-Y",
            allowInput: true,
        });
    });

    document.addEventListener("DOMContentLoaded", function() {
        // Initialize Flatpickr
        flatpickr("#ck_fdate", {
            dateFormat: "d-m-Y",
            defaultDate: "01-04-2022",
            allowInput: true,
        });
        flatpickr("#ck_tdate", {
            dateFormat: "d-m-Y",
           
            allowInput: true,
        });
    });
    document.addEventListener("DOMContentLoaded", function() {
        // Initialize Flatpickr
        flatpickr("#app_date", {
            dateFormat: "d-m-Y",
            mode: "range",
        });
    });
</script>


<script>
    $.fn.dataTable.ext.type.order['date-dd-mm-yyyy-pre'] = function(d) {
        if (d === null || d === "") {
            return Infinity;  // Treat empty dates as the largest value
        }
        return moment(d, 'DD-MM-YYYY').isValid() ? moment(d, 'DD-MM-YYYY').format('YYYYMMDD') : Infinity;
    };
    $(document).ready(function() {

  
    var totalSelQty = 0;
    var totalProjQty = 0;
    var totalprodQty = 0;
    var totalFrcQty = 0;
    var totalwoQty = 0;
    var totalcfmQty = 0;
    var totalshdiffQty = 0;
    var totalpastehdQty = 0;
    var totalshipQty = 0;
    var totalshortship = 0;
    var totalshippQty = 0;
    var totalshipdiff = 0;

    var totalfg =0;
    var totalunmapfg = 0;
    var totalfabric = 0;
    var totalunmapfabric = 0;
    var totaltim = 0;
    var totalunmaptrim = 0;
                                                   
    var table = $('#dataTablee').DataTable({
            paging: false,
            searching: true,
            ordering: true,
            
            order: [[0, 'asc']],  
            columnDefs: [
                {
                    targets: [5,6], 
                    type: 'date-dd-mm-yyyy'  
                },
                { orderable: false, targets: [17, 18] } 
            ],
            dom: 'Bfrtip',  
            buttons: [
            {
                extend: 'excelHtml5',
                text: 'Excel',
                autoFilter: true,
                titleAttr: 'Excel',

                exportOptions: {
                    format: {
                        body: function(data, row, column, node) {
                            // Use moment.js to convert dd-mm-yyyy to ISO date format yyyy-mm-dd for Excel


                            if ((column === 9 || column === 10 || column === 11) && /\d{2}-\d{2}-\d{4}/.test(data)) {
                                // Convert date to 'dd/mm/yyyy'
                                return moment(data, 'DD-MM-YYYY').format('YYYY-MM-DD');
                            } else {
                                // For other columns, return the data without changes
                                return $('<div>').html(data).text(); // Strips any HTML tags if present
                            }
                        }
                    }
                }

            },

            {
                extend: 'pdfHtml5',
                text: 'PDF',
                titleAttr: 'PDF',
                orientation: 'landscape',
                pageSize: 'A3',
                exportOptions: {
                    columns: ':visible'
                },
                customize: function(doc) {
                    doc.defaultStyle.fontSize = 7; // Reduce the font size
                    doc.content[1].table.widths = 'auto'; // Set column width to auto
                    doc.content[1].table.dontBreakRows = true; // Ensure content continues on the next page if too large
                }
                
            }
        ],
        
      
        footerCallback: function (row, data, start, end, display) {
           
                    var api = this.api();
                    
                    var totalSelQty = api.column(7, { search: 'applied' }).data().reduce(function(a, b) {
                        return (parseInt(a) || 0) + (parseInt(b) || 0);
                    }, 0);
                    
                   var totalProjQty = api.column(8, { search: 'applied' }).data().reduce(function(a, b) {
                    return (parseInt(a) || 0) + (parseInt(b) || 0);
                }, 0);
                
                    var totalFrcQty = api.column(9, { search: 'applied' }).data().reduce(function(a, b) {
                        return (parseFloat(a.toString().replace(/[^\d.-]/g, '')) || 0) + 
               (parseFloat(b.toString().replace(/[^\d.-]/g, '')) || 0);
                    }, 0);
                   
                    var totalprodQty = api.column(10, { search: 'applied' }).data().reduce(function(a, b) {
                        return (parseInt(a) || 0) + (parseInt(b) || 0);
                    }, 0);
                    var totalcfmQty = api.column(11, { search: 'applied' }).data().reduce(function(a, b) {
                        return (parseInt(a) || 0) + (parseInt(b) || 0);
                    }, 0);
                    var totalshdiffQty = api.column(12, { search: 'applied' }).data().reduce(function(a, b) {
                        return (parseInt(a) || 0) + (parseInt(b) || 0);
                    }, 0);
                    var totalshippQty = api.column(13, { search: 'applied' }).data().reduce(function(a, b) {
                        return (parseInt(a) || 0) + (parseInt(b) || 0);
                    }, 0);
                    var totalshipdiff = api.column(14, { search: 'applied' }).data().reduce(function(a, b) {
                        return (parseInt(a) || 0) + (parseInt(b) || 0);
                    }, 0);
                    var totalpastehdQty = api.column(15, { search: 'applied' }).data().reduce(function(a, b) {
                        return (parseInt(a) || 0) + (parseInt(b) || 0);
                    }, 0);
                    var totalshipQty = api.column(16, { search: 'applied' }).data().reduce(function(a, b) {
                        return (parseInt(a) || 0) + (parseInt(b) || 0);
                    }, 0);
                    var totalshortship  = api.column(17, { search: 'applied' }).data().reduce(function(a, b) {
                        return (parseInt(a) || 0) + (parseInt(b) || 0);
                    }, 0);
                    var totalfg = api.column(20, { search: 'applied' }).data().reduce(function(a, b) {
                        return (parseInt(a) || 0) + (parseInt(b) || 0);
                    }, 0);
                    var totalunmapfg = api.column(21, { search: 'applied' }).data().reduce(function(a, b) {
                        return (parseInt(a) || 0) + (parseInt(b) || 0);
                    }, 0);
                    var totalfabric  = api.column(22, { search: 'applied' }).data().reduce(function(a, b) {
                        return (parseInt(a) || 0) + (parseInt(b) || 0);
                    }, 0);
                    var totalunmapfabric  = api.column(23, { search: 'applied' }).data().reduce(function(a, b) {
                        return (parseInt(a) || 0) + (parseInt(b) || 0);
                    }, 0);
                    var totaltim  = api.column(24, { search: 'applied' }).data().reduce(function(a, b) {
                        return (parseInt(a) || 0) + (parseInt(b) || 0);
                    }, 0);
                    var totalunmaptim  = api.column(25, { search: 'applied' }).data().reduce(function(a, b) {
                        return (parseInt(a) || 0) + (parseInt(b) || 0);
                    }, 0);


                    
                    // Update footer with totals
                    $('#totalSelQty').html(totalSelQty);
                    
                  
                    $('#totalprodQty').html(totalprodQty);
                    $('#totalcfmQty').html(totalcfmQty);
                   
                   
                    $('#totalpastehdQty').html(totalpastehdQty);
                    $('#totalshipQty').html(totalshipQty);
                    $('#totalshortship').html(totalshortship);
                    $('#totalshippQty').html(totalshippQty);
                    $('#totalshipdiff').html(totalshipdiff);
                    $('#totalfg').html(totalfg);
                    $('#totalunmapfg').html(totalunmapfg);
                    $('#totalfabric').html(totalfabric);
                    $('#totalunmapfabric').html(totalunmapfabric);
                    $('#totaltim').html(totaltim);
                    $('#totalunmaptrim').html(totalunmaptim);
                }
           
        });

        function getNumericValue(cellData) {
    var $cell = $(cellData); // Use jQuery to create a jQuery object
    // If the cell contains a span, get its text
    var value = $cell.find('span').first().text().trim();
    parseInt(value.replace(/[^\d.-]/g, '')) || 0;
    return  parseInt(value.replace(/[^\d.-]/g, '')) || 0; // Return parsed integer or 0 if not a number
}

    // Load data on page load
    $("#preloder").fadeIn();
    loadData();

    // Filter form submission
    $('#filterForm').on('submit', function(e) {
        $("#preloder").fadeIn();
        e.preventDefault();
        loadData();
    });

    $('#resetButton').on('click', function() {
        // Reset the form fields
        $('#filterForm')[0].reset();
        $("#preloder").fadeIn();
        // Clear dynamically populated dropdowns
        $('#buyer_name').empty().append('<option value="">Select Buyer</option>');
        $('#brand').empty().append('<option value="">--Select Brand PO NO--</option>');
        $('#season').empty().append('<option value="">--Select Season--</option>');
        $('#merch_name').empty().append('<option value="">--Select Merch Name--</option>');
        $('#cc').empty().append('<option value="">--Select CC--</option>');
        $('#model_color').empty().append('<option value="">--Select Model+Color--</option>');

        flatpickr("#ck_fdate", {
            dateFormat: "d-m-Y",
            defaultDate: "01-04-2022",
            allowInput: true,
        });
        // Reload data with default values
        loadData();
    });

    // Function to load data based on filters
    function loadData() {
        var buyer_nameselected = $('#buyer_name option:selected').map(function() {
                return $(this).val();
            }).get();
        var buyerjoinedValues = buyer_nameselected.join(', ');
        var buyerNamee = buyerjoinedValues;

        console.log('buyer' + buyerNamee );
        
        var division = $('#division').val();
        var ckfdate = $('#ck_fdate').val();
        var cktdate = $('#ck_tdate').val();
        var shipfdate = $('#shipment_fdate').val();
        var shiptdate = $('#shipment_tdate').val();

        var brand_nameselected = $('#brand option:selected').map(function() {
                return $(this).val();
            }).get();
        var brandjoinedValues = brand_nameselected.join(', ');
        
        
        var brand = brandjoinedValues;

        var merch_nameselected = $('#merch_name option:selected').map(function() {
                return $(this).val();
            }).get();
        var merchjoinedValues = merch_nameselected.join(', ');
        var merch_namee = merchjoinedValues;
        var seasonselected = $('#season option:selected').map(function() {
                return $(this).val();
            }).get();
        var seasonjoinedValues = seasonselected.join(', ');
        
        var season = seasonjoinedValues;

        var ccselected = $('#cc option:selected').map(function() {
                return $(this).val();
            }).get();
        var ccjoinedValues = ccselected.join(', ');
        
        var cc = ccjoinedValues;

        var model_colorselected = $('#model_color option:selected').map(function() {
                return $(this).val();
            }).get();
        var model_colorjoinedValues =model_colorselected.join(', ');
        
        
       
        var modelcolor = model_colorjoinedValues;
        $.ajax({
            url: "{{ route('merchandiserorder_technotek') }}",
            type: "GET",
            data: $('#filterForm').serialize(),

            success: function(data) {
                $("#preloder").fadeOut();

                var table = $('#dataTablee').DataTable();
                table.clear().draw();// Clear the existing data
                var ocnNumbers = [];
                var uniqueBuyers = [];
                var ccNOarr = [];
                var MerchName = [];
                var Brandarr = [];
                var divisionarr = [];
                var seasonarr = [];
                var model_colorarr = [];
                var ccarr = [];
                var newCount = 1;
                var ckdatearr = [];
                var shipdatearr = [];
                

                $.each(data.result, function(index, row) {
                    var color = '';
                    var color_qty = '';
                    var titleex = '';
                    var totalpoqty = parseInt(row.Ship_Qty) + parseInt(row.Ship_Diff);
                   // Convert values to integers with fallback for invalid numbers
                    var prjQty = parseInt(row.PRJ_Qty, 10) || 0;
                    var cfmQty = parseInt(row.CFM_Qty, 10) || 0;
                    var frcQty = parseInt(row.FRC_Qty, 10) || 0;
                    var Ship_Qty = parseInt(row.Ship_Qty, 10) || 0;

                    if (prjQty < frcQty) {
                        // Conditional styling
                       // var titleex = prjQty - frcQty; 
                        //if(titleex > 0){
                            var color_qty = 'red !important'; 
                        //}   // Calculate difference
                    }

                    if(frcQty < Ship_Qty){
                        var color = 'red !important';
                        var titleex =  parseInt(row.PRJ_Qty) - parseInt(row.FRC_Qty);
                    }

                    var modelcolor = row['Model \\ Color'];
                    table.row.add([
                       '<span style=" justify-content: center; align-items: center; display: flex;">'+ newCount +'</span>',
                        row.CCNo,
                        row.Col_Lookup,
                        row['DMI/DSI'],
                        
                         row.Seas_Lookup,
                         formatDateCk(row.CK_Date),
                         formatDateCk(row.Ship_Date),
                         
                       
                         row.Selection_Qty,
                        '<span style="cursor: pointer; color: blue; " data-bs-toggle="modal" data-bs-target="#tableModalocrstatus" data-division ="'+row.Division+'"  data-cc-no="' + row.Cost_ID + '"  data-model_color="'+ row.CCNo +'_'+ modelcolor +'(' + row.PRJ_Qty +')' +'" class="tadetails" title="'+titleex+'">'+row.PRJ_Qty+'</span>',
                      
                        '<span style="cursor: pointer; color: blue; color :'+color_qty+'" data-bs-toggle="modal" data-bs-target="#tableModalfcrstatus" data-division ="'+row.Division+'"  data-cc-no="' + row.Cost_ID + '"  data-model_color="'+ row.CCNo +'_'+ modelcolor +'(' + row.FRC_Qty +')' +'" class="fcr_tadetails" title="FRC Status">'+row.FRC_Qty+'</span>',
                      
                       
                        row.CutOrd_Qty,
                        row.Prod_Qty,
                        '<span style ="color:'+color+'">'+row.CFM_Qty+'</span>',
                       
                        row.Ship_Qty
                       ,
                        row.Ship_Diff,
                        '' ,
                        row.Past_EHD,
                        
                        row.Short_Ship,
                      
                       
                        '<span title="' + row.Brand +'">'+row.Brand.substring(0, 5)+'</span>',
                        '<span title="' + row.Merch_Name +'">'+row.Merch_Name.substring(0, 5)+'</span>',
                        row.Fgs_stock_Qty,
                        row.Unmap_Fgs_Stock_Qty,
                        row.Fabric_Qty,
                        row.Unmap_Fabric_Qty,
                        row.Trim_Value,
                        row.Unmap_Trim_Value,
                       
                    ]).draw(false);  // Add new row and redraw table
                    newCount++;
                   
                    //table.fixedColumns().update();


                    // Collect unique buyers and OCN numbers for dropdowns
                    if (row.Buyer_Name) {
                        uniqueBuyers.push(row.Buyer_Name);
                    }
                    if (row.CCNo) {
                        ccNOarr.push(row.CCNo);
                    }
                    if (row.Brand) {
                        Brandarr.push(row.Brand);
                    }
                    if (row.Merch_Name) {
                        MerchName.push(row.Merch_Name);
                    }
                    if (row.Division) {
                        divisionarr.push(row.Division);
                    }
                    if (row.Season) {
                        seasonarr.push(row.Season);
                    }
                    if (modelcolor) {
                        model_colorarr.push(modelcolor);
                    }
                    if (row.CK_Date) {
                        ckdatearr.push(row.CK_Date);
                    }
                    if (row.CK_Date) {
                        ckdatearr.push(row.CK_Date);
                    }
                    if(row.Ship_Date){
                        shipdatearr.push(row.Ship_Date)
                    }
                   
                });


                
                
    
   
                // Populate the buyer dropdown with unique buyers from the result
                if (buyerNamee == '') {
                    
                    $('#buyer_name').select2({
                            placeholder: "Select Buyer",
                            allowClear: true 
                        });
                    $.each([...new Set(uniqueBuyers)], function(index, value) {
                        $('#buyer_name').append('<option value="' + value + '">' + value + '</option>');
                    });
                } else {
                    var commArray = buyerNamee.split(',');
                    commArray.forEach(function(buyerName) {
                        $('#buyer_name option[value="' + buyerName.replace(/"/g, '\\"') + '"]').prop('selected', true);
                    });
                }
                if (brand == '') {
                    $('#brand').select2({
                            placeholder: "Select Brand",
                            allowClear: true 
                        });
                    $.each([...new Set(Brandarr)], function(index, value) {
                        $('#brand').append('<option value="' + value + '">' + value + '</option>');
                    });
                } else {
                    var commArray = brand.split(',');
                    commArray.forEach(function(brand) {
                        $('#brand_name option[value="' + brand.replace(/"/g, '\\"') + '"]').prop('selected', true);
                    });
                    
                }

                // Populate the OCN dropdown with unique values from the table
                if (division == '') {
                    $('#division').select2({
                            placeholder: "Select Division",
                            allowClear: true 
                        });
                    $.each([...new Set(divisionarr)], function(index, value) {
                        $('#division').append('<option value="' + value + '">' + value + '</option>');
                    });
                } else {
                    $('#division option[value="' + division.replace(/"/g, '\\"') + '"]').prop('selected', true);
                }
                
                if (merch_namee == '') {
                    $('#merch_name').select2({
                            placeholder: "Select Merchandiser Name",
                            allowClear: true 
                        });
                   
                    $.each([...new Set(MerchName)], function(index, value) {
                        $('#merch_name').append('<option value="' + value + '">' + value + '</option>');
                    });
                } else {
                    var commArray = merch_namee.split(',');
                    commArray.forEach(function(merch_namee) {
                        $('#merch_name option[value="' + merch_namee.replace(/"/g, '\\"') + '"]').prop('selected', true);
                    });
                    
                }
                if (season == '') {
                    $('#season').select2({
                            placeholder: "Select Season",
                            allowClear: true 
                        });
                    
                    $.each([...new Set(seasonarr)], function(index, value) {
                        $('#season').append('<option value="' + value + '">' + value + '</option>');
                    });
                } else {
                    var commArray = season.split(',');
                    commArray.forEach(function(season) {
                        $('#season option[value="' + season.replace(/"/g, '\\"') + '"]').prop('selected', true);
                    });
                    
                }
                if (modelcolor == '') {
                    $('#model_color').select2({
                            placeholder: "Select Model Color",
                            allowClear: true 
                        });

                   
                    $.each([...new Set(model_colorarr)], function(index, value) {
                        $('#model_color').append('<option value="' + value + '">' + value + '</option>');
                    });
                } else {
                    var commArray = modelcolor.split(',');
                    commArray.forEach(function(modelcolor) {
                        $('#model_color option[value="' + modelcolor.replace(/"/g, '\\"') + '"]').prop('selected', true);
                    });

                   
                }
                if (cc == '') {
                    $('#cc').select2({
                            placeholder: "Select CC",
                            allowClear: true 
                        });

                    
                    $.each([...new Set(ccNOarr)], function(index, value) {
                        $('#cc').append('<option value="' + value + '">' + value + '</option>');
                    });
                } else {
                    var commArray = cc.split(',');
                    commArray.forEach(function(cc) {
                        $('#cc option[value="' + cc.replace(/"/g, '\\"') + '"]').prop('selected', true);
                    });

                   
                }
            }
        });
    }

  
    });

</script>











<!--supplier po popup-->


<!--T & A details popup-->
<script>
   

//TEchnoteck

function convertToDate(dateStr) {
     const [day, month, year] = dateStr.split('-');
      return new Date(`${year}-${month}-${day}`);
    }
    function formatDateCk(dateString) {

       
    if (!dateString || typeof dateString !== 'string') {
        return '';  // Handle invalid date input
       // console.log('Invalid');
    }

    var parts = dateString.split("-");
    
    if (parts.length === 3) {
        var day = parts[2];
        var month = parts[1];
        var year = parts[0];
        var year = parts[0];
        //console.log(year);
       

        if (year.length === 4 && !isNaN(year) && !isNaN(day) && !isNaN(month)) {
            var shortYear = year.substring(2);  // Extract last two digits of the year
            return `${day}-${month}-${shortYear}`;  // Use template literals for readability
        } else {
            return '';  // Handle incorrect year length or non-numeric values
        }
    } else {
        return '';  // Handle incorrect date format
    }
}

$(document).ready(function() {
  
  $('.select2').select2({
     // placeholder: "Select Season", // Placeholder text
      allowClear: true // Allows clearing the selection
  });


  
});


function handleDivisionChange() {
        // alert('dfghjkl');
        $('#filter_button').attr('disabled', true);

        var buyer_nameselected = $('#buyer_name option:selected').map(function() {
            return $(this).val();
        }).get();
        var buyerjoinedValues = buyer_nameselected.join(', ');
        var buyerNamee = buyerjoinedValues;

        var division = $('#division').val();
        var ckfdate = $('#ck_fdate').val();
        var cktdate = $('#ck_tdate').val();
        var shipfdate = $('#shipment_fdate').val();
        var shiptdate = $('#shipment_tdate').val();

        // BRAND //
        var brand_nameselected = $('#brand option:selected').map(function() {
            return $(this).val();
        }).get();
        var brandjoinedValues = brand_nameselected.join(', ');

        var brand = brandjoinedValues;

        // SEASON //
        var merch_nameselected = $('#merch_name option:selected').map(function() {
            return $(this).val();
        }).get();
        var merchjoinedValues = merch_nameselected.join(', ');
        var merch_namee = merchjoinedValues;
        var seasonselected = $('#season option:selected').map(function() {
            return $(this).val();
        }).get();
        var seasonjoinedValues = seasonselected.join(', ');

        var season = seasonjoinedValues;

        // CC //
        var ccselected = $('#cc option:selected').map(function() {
            return $(this).val();
        }).get();
        var ccjoinedValues = ccselected.join(', ');

        var cc = ccjoinedValues;

       

        // MODEL + COLOR //
        var model_colorselected = $('#model_color option:selected').map(function() {
            return $(this).val();
        }).get();
        var model_colorjoinedValues = model_colorselected.join(', ');



        var modelcolor = model_colorjoinedValues;

        // BUYER NAME
        $('#buyer_name').change(function() {
            // Check if any option is selected
            if ($(this).val() && $(this).val().length > 0) {
                $('#buyer_name option').prop('disabled', false);
                $('#spinner_BUY').hide();
            } else {
                $('#buyer_name option').prop('disabled', true);
                $('#spinner_BUY').show();
            }
        });

        // BRAND
        $('#brand').change(function() {
            // Check if any option is selected
            if ($(this).val() && $(this).val().length > 0) {
                $('#brand option').prop('disabled', false);
                $('#spinner_BRAN').hide();
            } else {
                $('#brand option').prop('disabled', true);
                $('#spinner_BRAN').show();
            }
        });

        // SEASON
        $('#season').change(function() {
            // Check if any option is selected
            if ($(this).val() && $(this).val().length > 0) {
                $('#season option').prop('disabled', false);
                $('#spinner_SEA').hide();
            } else {
                $('#season option').prop('disabled', true);
                $('#spinner_SEA').show();
            }
        });


        // CC 
        $('#cc').change(function() {
            // debugger;
            // Check if any option is selected
            if ($(this).val() && $(this).val().length > 0) {
                $('#cc option').prop('disabled', false);
                $('#spinner_CC').hide();

            } else {
                $('#cc option').prop('disabled', true);
                $('#spinner_CC').show();
            }
        });

        // MODEL+COLOR
        $('#model_color').change(function() {
            // Check if any option is selected
            if ($(this).val() && $(this).val().length > 0) {
                $('#model_color option').prop('disabled', false);
                $('#spinner_MOD').hide();
            } else {
                $('#model_color option').prop('disabled', true);
                $('#spinner_MOD').show();
            }
        });

        // $('#buyer_name option').prop('disabled', true);
        // $('#spinner_BUY').show();
        // $('#brand option').prop('disabled', true);
        // $('#spinner_BRAN').show();
        // $('#season option').prop('disabled', true);
        // $('#spinner_SEA').show();
        // $('#cc option').prop('disabled', true);
        // $('#spinner_CC').show();
        // $('#model_color option').prop('disabled', true);
        // $('#spinner_MOD').show();

        // AJAX //


        console.log($('#filterForm').serialize() + 'change');
        $.ajax({
            url: "{{ route('merchandiserorder_technotek_filter') }}",
            type: "GET",
            data: $('#filterForm').serialize(),

            success: function(response) {
                //$("#preloder").fadeOut();

                console.log(response);

                var ocnNumbers = [];
                var uniqueBuyers = [];
                var ccNOarr = [];
                var MerchName = [];
                var Brandarr = [];
                var divisionarr = [];
                var seasonarr = [];
                var model_colorarr = [];
                var ccarr = [];
                var newCount = 1;
                var ckdatearr = [];
                var shipdatearr = [];



                var uniqueBuyer = response.buyer;
                var Brandarr = response.brand;
                var divisionarr = response.division;
                var seasonarr = response.season;
                var MerchName = response.merch_name;
                var model_colorarr = response.modelcolor;
                var ccNOarr = response.ccno;

                //console.log(model_colorarr);




                // Populate the buyer dropdown with unique buyers from the result
                if (buyerNamee == '') {

                    $('#buyer_name').select2({
                        placeholder: "Select Buyer",
                        allowClear: true
                    });


                    // Clear the dropdown and add a placeholder option
                    $('#buyer_name').empty().append('<option value="">Select Buyer </option>');
                    
                    // Populate dropdown with options from response
                    $.each(response.buyer, function(index, value) {
                        $('#buyer_name').append('<option value="' + value + '">' + value + '</option>');
                    });

                } else {
                    var commArray = buyerNamee.split(',');
                    commArray.forEach(function(buyerName) {
                        $('#buyer_name option[value="' + buyerName.replace(/"/g, '\\"') + '"]').prop('selected', true);
                    });
                }
                if (brand == '') {
                    $('#brand').select2({
                        placeholder: "Select Brand",
                        allowClear: true
                    });

                    // Clear the dropdown and add a placeholder option
                    $('#brand').empty().append('<option value="">Select Brand </option>');

                    // Populate dropdown with options from response
                    $.each(response.brand, function(index, value) {
                        $('#brand').append('<option value="' + value + '">' + value + '</option>');
                    });

                } else {
                    var commArray = brand.split(',');
                    commArray.forEach(function(brand) {
                        $('#brand option[value="' + brand.replace(/"/g, '\\"') + '"]').prop('selected', true);
                    });

                }


                if (season == '') {
                    $('#season').select2({
                        placeholder: "Select Season",
                        allowClear: true
                    });
                    // Clear the dropdown and add a placeholder option
                    $('#season').empty().append('<option value="">Select Season </option>');


                    // Populate dropdown with options from response
                    $.each(response.season, function(index, value) {
                        $('#season').append('<option value="' + value + '">' + value + '</option>');
                    });

                } else {
                    var commArray = season.split(',');
                    commArray.forEach(function(season) {
                        $('#season option[value="' + season.replace(/"/g, '\\"') + '"]').prop('selected', true);
                    });

                }
                if (modelcolor == '') {
                    // Initialize select2 with placeholder and allowClear option
                    $('#model_color').select2({
                        placeholder: "Select Model Color",
                        allowClear: true,
                    });
                    // Clear the dropdown and add a placeholder option
                    $('#model_color').empty().append('<option value="">Select Model Color</option>');

                    // Populate dropdown with options from response
                    $.each(response.modelcolor, function(index, value) {
                        $('#model_color').append('<option value="' + value + '">' + value + '</option>');
                    });
                } else {
                    // Split the modelcolor string into an array (comma-separated values)
                    var commArray = modelcolor.split(',');


                    // Loop through the array and mark corresponding options as selected
                    commArray.forEach(function(color) {
                        $('#model_color option[value="' + color.replace(/"/g, '\\"') + '"]').prop('selected', true);
                    });

                    // Refresh the select2 dropdown to reflect the changes
                    //$('#model_color').trigger('change');
                }

                if (cc == '') {
                    $('#cc').select2({
                        placeholder: "Select CC",
                        allowClear: true
                    });
                    
                    // Clear the dropdown and add a placeholder option
                    $('#cc').empty().append('<option value="">Select CC </option>');

                    // Populate dropdown with options from response
                    $.each(response.ccno, function(index, value) {
                        $('#cc').append('<option value="' + value + '">' + value + '</option>');
                    });

                } else {
                    var commArray = cc.split(',');
                    commArray.forEach(function(cc) {
                        $('#cc option[value="' + cc.replace(/"/g, '\\"') + '"]').prop('selected', true);
                    });


                }

                $('#buyer_name option').prop('disabled', false);
                $('#spinner_BUY').hide();
                $('#brand option').prop('disabled', false);
                $('#spinner_BRAN').hide();
                $('#season option').prop('disabled', false);
                $('#spinner_SEA').hide();
                $('#cc option').prop('disabled', false);
                $('#spinner_CC').hide();
                $('#model_color option').prop('disabled', false);
                $('#spinner_MOD').hide();
                $('#filter_button').attr('disabled', false);

            }
        });
    }




$(document).ready(function() {
        // Attach a change event handler to the select element
        $('.selectclass').on('change', function() {
            var selectedValue = $(this).val(); // Get the selected value
            var selectedid = $(this).attr('id'); // Get the selected value
            console.log("Selected Division: " + selectedValue);

            var buyer_Id = $("#buyer_name").attr("id");
            var brand_Id = $("#brand").attr("id");
            var season_Id = $("#season").attr("id");
            var cc_Id = $("#cc").attr("id");
            var modColor_Id = $("#model_color").attr("id");

            if (selectedid != buyer_Id) {
                //$('#buyer_name option').prop('disabled', true);
                $('#spinner_BUY').show();
            }
            if (selectedid != brand_Id) {
                //$('#brand option').prop('disabled', true);
                $('#spinner_BRAN').show();

            }
            if (selectedid != season_Id) {
               // $('#season option').prop('disabled', true);
                $('#spinner_SEA').show();

            }
            if (selectedid != cc_Id) {
                //$('#cc option').prop('disabled', true);
                $('#spinner_CC').show();

            }
            if (selectedid != modColor_Id) {
                //$('#model_color option').prop('disabled', true);
                $('#spinner_MOD').show();
            }



            // Call any function you want when the value changes
            // For example, you could call another function to update other parts of the page
            handleDivisionChange();
        });
    });
</script>
@endsection



